/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	FlashPlayer
**
** DESCRIPTION:	Interface for flash player
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef FLASH_PLAYER_INTERFACE_H
#define FLASH_PLAYER_INTERFACE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class IFlashPlayer
{
	//interface methods
	//setup

	public: virtual ~IFlashPlayer() {}
	//process
	public:		virtual const bool Load(const char *psFileName, const int iWidth, const int iHeight) = 0;
	public:     virtual void Shutdown() {}
	public:		virtual const bool GetFrameBuffer(unsigned char **ppImageData) = 0;
	public:		virtual void Play(void) const = 0;
	public:		virtual void Pause(void) const = 0;
	public:		virtual void Stop(void) const = 0;
	public:		virtual void GotoFrame(const int iFrame) const = 0;

	//access
	public:		virtual const bool IsPlaying(void) const = 0;
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/